unit mSudoku;

interface
uses Sysutils;
const stoppZahl=81; // spaeter 81
type
  tZiffMenge = set of 0..9;  // Menge vorkommender Ziffern
type TSudoku = class
  private
    merkZeile, merkSpalte, merkKasten : array[0..8] of tZiffMenge;
    F : array[0..80] of integer;
    gesetzt: array[0..80] of boolean;  //gesetzte Zahl
    //getestet: array [0..80] of integer;  //wie weit getestet
    function kastenNr (j : integer) : integer;
    function testen(n, test : integer):boolean;
    procedure setzen(n, test : integer);
    procedure ruecknehmen(n, test : integer);
    procedure loesen;
    procedure AllesMerken;
  public
    constructor create;
    procedure Loese;
    procedure ZahlSchreiben (wohin: integer; was : string);
    function ZahlLesen (welche : integer) : integer;
end;

implementation

constructor TSudoku.create;
var i : integer;
begin
  for i := 0 to 80 do begin
        F[i] :=0;
        gesetzt[i] := false;
        //getestet[i] := 0;
        end;
end;

procedure TSudoku.Loese;
var fertig : boolean;
begin
  AllesMerken;
  fertig := false;
  loesen;
end;

procedure TSudoku.AllesMerken;
var i : integer;
begin
  for i := 0 to 8 do begin
   merkZeile[i] := [];
   merkSpalte[i] := [];
   merkKasten[i] := [];
 end;
 for i := 0 to 80 do
   if F[i] > 0 then begin
     merkZeile[i div 9] := merkZeile[i div 9] + [F[i]];
     merkSpalte[i mod 9] := merkSpalte[i mod 9] + [F[i]];
     merkKasten[kastenNr(i)] := merkKasten[kastenNr(i)] + [F[i]];
     gesetzt[i] := true;
   end;
end;

procedure TSudoku.loesen;
var  testzahl,n : integer; vorwaerts:boolean;
begin vorwaerts := true; n :=-1;
  // Hier die Lsung einfgen






  
end;

function TSudoku.testen(n, test : integer): boolean;
begin
  if (test>0) and (test<10) and
     (not (test in merkZeile[n div 9])) and
     (not (test in merkSpalte[n mod 9])) and
     not (test in merkKasten[kastenNr(n)])
  then testen := true else testen := false;
 
end;
procedure TSudoku.setzen(n, test : integer);
begin
   merkZeile[n div 9] := merkZeile[n div 9] + [test];
   merkSpalte[n mod 9] := merkSpalte[n mod 9] + [test];
   merkKasten[kastenNr(n)] := merkKasten[kastenNr(n)] + [test];
   F[n] := test;
end;
procedure TSudoku.ruecknehmen(n, test : integer);
begin
  merkZeile[n div 9] := merkZeile[n div 9] - [test];
  merkSpalte[n mod 9] := merkSpalte[n mod 9] - [test];
  merkKasten[kastenNr(n)] := merkKasten[kastenNr(n)] - [test];
  F[n] := 0;
end;

function TSudoku.kastenNr (j : integer) : integer;
begin
  kastenNr := 3 * (j div 27) + (j div 3) mod 3
end;

procedure TSudoku.ZahlSchreiben (wohin: integer; was : string);
begin F[wohin] := strToInt(was); end;

function TSudoku.ZahlLesen (welche : integer) : integer;
begin  ZahlLesen := F[welche] end;

end.
 